import java.util.*;

public class Main {

    public static void main(String[] args) {
        Scanner ulaz = new Scanner(System.in);

        int n = ulaz.nextInt();
        int[][] tacke = new int[n][2];
        for (int i = 0; i < n; i++) {
            tacke[i][0] = ulaz.nextInt();
            tacke[i][1] = ulaz.nextInt();
        }

        Arrays.sort(tacke, (a, b) -> a[0] != b[0] ? a[0] - b[0] : a[1] - b[1]);

        List<int[]> omotac = nadjiOmotac(tacke, n);
        int najmanjaPovrsina = Integer.MAX_VALUE;

        for (int i = 0; i < n; i++) {
            List<int[]> noveTacke = new ArrayList<>();
            for (int j = 0; j < n; j++) {
                if (i != j) {
                    noveTacke.add(tacke[j]);
                }
            }
            List<int[]> noviOmotac = nadjiOmotac(noveTacke.toArray(new int[0][0]), n - 1);
            najmanjaPovrsina = Math.min(najmanjaPovrsina, izracunajPovrsinu(noviOmotac));
        }

        System.out.println(najmanjaPovrsina);
    }

    private static List<int[]> nadjiOmotac(int[][] tacke, int n) {
        List<int[]> omotac = new ArrayList<>();
        for (int i = 0; i < n; i++) {
            while (omotac.size() >= 2 && orijentacija(omotac.get(omotac.size() - 2), omotac.get(omotac.size() - 1), tacke[i]) <= 0) {
                omotac.remove(omotac.size() - 1);
            }
            omotac.add(tacke[i]);
        }
        int pocetnaVelicina = omotac.size();
        for (int i = n - 2; i >= 0; i--) {
            while (omotac.size() > pocetnaVelicina && orijentacija(omotac.get(omotac.size() - 2), omotac.get(omotac.size() - 1), tacke[i]) <= 0) {
                omotac.remove(omotac.size() - 1);
            }
            omotac.add(tacke[i]);
        }
        omotac.remove(omotac.size() - 1);
        return omotac;
    }

    private static int orijentacija(int[] a, int[] b, int[] c) {
        return (b[0] - a[0]) * (c[1] - a[1]) - (b[1] - a[1]) * (c[0] - a[0]);
    }

    private static int izracunajPovrsinu(List<int[]> omotac) {
        int povrsina = 0;
        int n = omotac.size();
        for (int i = 0; i < n; i++) {
            int[] a = omotac.get(i);
            int[] b = omotac.get((i + 1) % n);
            povrsina += a[0] * b[1] - a[1] * b[0];
        }
        return Math.abs(povrsina) / 2;
    }
}